/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ProcessRunnable;
import com.aptana.core.util.ProcessStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class SudoProcessRunnable
extends ProcessRunnable {
    private char[] password;
    private String echoMessage;

    public SudoProcessRunnable(Process p, char[] password, String echoMessage) {
        super(p, null, true);
        this.password = password;
        this.echoMessage = echoMessage;
    }

    public void run() {
        StringBuilder builder = new StringBuilder();
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new InputStreamReader(this.p.getInputStream(), "UTF-8"));
                if (this.password != null) {
                    PrintWriter pwdWriter = new PrintWriter(this.p.getOutputStream());
                    pwdWriter.println(this.password);
                    pwdWriter.flush();
                }
                int exitCode = 1;
                StringBuilder line = new StringBuilder();
                int charRead = 0;
                while ((charRead = br.read()) != -1) {
                    char c = (char)charRead;
                    line.append(c);
                    if (c == '\n') {
                        String lineString = line.toString();
                        line = new StringBuilder();
                        builder.append(lineString);
                        if (lineString.contains(this.echoMessage)) {
                            exitCode = 0;
                            break;
                        }
                    }
                    if (this.isReady(br, 3, 500L)) continue;
                    exitCode = 1;
                    break;
                }
                this.p.destroy();
                this.status = new ProcessStatus(exitCode, builder.toString(), builder.toString());
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), e);
                this.status = new Status(4, "com.aptana.core", e.getMessage(), (Throwable)e);
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.monitor.done();
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
            this.monitor.done();
        }
    }

    private boolean isReady(Reader br, int maxAttempts, long sleepInterval) throws IOException {
        int waitCount = 0;
        while (!br.ready()) {
            if (waitCount >= maxAttempts) {
                return false;
            }
            try {
                Thread.sleep(sleepInterval);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++waitCount;
        }
        return true;
    }
}

